/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05; import java.io.*;
import lotus.domino.*; 
import javax.servlet.http.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DominoServletConPoolOneUserAdvanced extends HttpServlet {

	private final ConnectionPool pool = ConnectionPool.getConnectionPool();

	/**
	 * Connection Pooling Servlet <br>
	 * Auf Basis der ConnectionPool Klasse.
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws IOException {
		Session session = null;
		try {
			PrintWriter out = resp.getWriter();
			resp.setContentType("text/html"); 
			out.println ("<html><head>\n" +
					"<title>Domino Servlet DominoServletConPoolOneUserAdvanced</title>\n<style>\n" +
					"\tbody {font-family:Helvetica,Arial,sans-serif;}\n" +
					"\th1 {color:#FF00FF;}\n</style>\n</head>\n" +
					"<body>\n<h1>Connection Pooling Servlet</h1>\n");
			out.println((pool.showToken()==null)?"<br/>New Session":"<br/>Token = " + pool.showToken());
			session = pool.getSession();
			out.println("<br/>Name = " + session.getUserName());
			out.println("<br/>Count = " + pool.getCount());
			out.println("<br/>concurrent Count = " + pool.getConcurrentCount());
			printInfo(session,out);
			out.println("</body></html>");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			ConnectionPool.recycleSession(session);
		}
	}
	
	private static void printInfo(Session s, PrintWriter out)
	throws NotesException {
		out.println ("<pre>SessionClass\t= " + s.getClass().getName());
		out.println ("Platform\t\t= " + s.getPlatform());
		out.println ("Version\t\t\t= " + s.getNotesVersion());
		out.println ("User\t\t\t= " + s.getUserName());
		out.println ("Session Token\t= " + s.getSessionToken());
		out.println ("Servername\t\t= <<" + s.getServerName() + ">>\n</pre>");	
		Database db = null;
		try {
			db=s.getDatabase("","djbuch/djbuch.nsf");
			out.println (db.getTitle());
			out.println (db.getAllDocuments().getFirstDocument().getItemValueString ("Form"));
		} finally {
			db.recycle();
		}
	}
}